#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"
#include "../generator.h"

#define FLAQUE_X2 (15)
#define FLAQUE_Y2 (15)

static Obj3d *pFlaque2;
static float Matrix[16], Matrix2[16];

void LInit_Flaque2()
{
	int Cpt1, Cpt2, Cpt3=0;
	float Tmp1, Tmp2, Tmp3;

	pFlaque2 = GenerateFloor(FLAQUE_X2, FLAQUE_Y2, 800, 600, 192, 128);

	for(Cpt2=0;Cpt2<FLAQUE_Y2+1;Cpt2++)
	{
		for(Cpt1=0;Cpt1<FLAQUE_X2+1;Cpt1++)
		{
			pFlaque2->pVertexIn[Cpt3].z = 
						1000.f * (float)sin(Cpt1/(float)FLAQUE_X2*PI)
						+ 1000.f * (float)sin(Cpt2/(float)FLAQUE_Y2*PI) - 700;
			Tmp1 = (float)sin(Cpt2/(float)(FLAQUE_Y2+1)*PI);
			Tmp2 = (float)sin(Cpt1/(float)(FLAQUE_X2+1)*PI);
			Tmp3 = (Tmp1+Tmp2)/2;
			pFlaque2->pVertexOut[Cpt3].r = (float)pow(Tmp1,1)*255;
			pFlaque2->pVertexOut[Cpt3].g = (float)pow(Tmp2,1)*255;
			pFlaque2->pVertexOut[Cpt3].b = (float)pow(Tmp3,1)*255;
			Cpt3++;
		}
	}

	PrepareTextureFromArray(g_PicBof, 256, 256, &g_TextureBof);
	BeIdentityMatrix(Matrix);
	TranslateMatrix(Matrix,0,0,500);
}

void QInit_Flaque2()
{
	grSstControl(GR_CONTROL_ACTIVATE);

	grColorMask(FXTRUE, FXFALSE);

	grDepthBufferMode(GR_DEPTHBUFFER_DISABLE);
	grAlphaCombine(GR_COMBINE_FUNCTION_LOCAL, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_NONE, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	grAlphaTestFunction(GR_CMP_ALWAYS);

	DownloadTexture(&g_TextureBof);
	SelectTexture(g_TextureBof);
	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grCullMode(GR_CULL_DISABLE);
	grFogMode(GR_FOG_DISABLE);
}

void Effect_Flaque2()
{
	int Img1, Cpt1;
	float DirCos, DirSin;

	Img1 = g_demostate.TickInEffect/10;

	DirCos = 2*(float)cos(Img1/360.f);
	DirSin = 2*(float)sin(Img1/360.f);

	for(Cpt1=0;Cpt1<(FLAQUE_X2+1)*(FLAQUE_Y2+1);Cpt1++)
	{
		pFlaque2->pVertexIn[Cpt1].tmuvtx[0].sow += DirCos;
		pFlaque2->pVertexIn[Cpt1].tmuvtx[0].tow += DirSin;
	}
	BeIdentityMatrix(Matrix);
	RotateZMatrix(Matrix2, Matrix, 2048*SinTable[g_demostate.TickInEffect&8191]);
	DrawWithMatrix(pFlaque2, Matrix2, 0, 0, 0);
}

void ByeBye_Flaque2()
{
	FreeTexture(&g_TextureBof);
}